﻿Public Class Message

    Public Shared SeparatorCharacter As String = ":"

    Friend Property Source As String
    Friend Property Action As String
    Friend Property Text As String
    Friend Property Target As String
    Friend Property FactoidNumber As String


    Sub New(source As String, action As String, text As String, target As String, factoidNumber As String)
        Me.Source = source
        Me.Action = action
        Me.Text = text
        Me.Target = target
        Me.FactoidNumber = factoidNumber
    End Sub

    Private Sub New()

    End Sub

    Public Overrides Function ToString() As String
        Return Source & Message.SeparatorCharacter & Action & Message.SeparatorCharacter & Text & Message.SeparatorCharacter & Target & Message.SeparatorCharacter & FactoidNumber
    End Function

    Public Function PrintFields(Optional numTabIndents As Integer = 0) As String
        Return Me.PrintFields(Me.GetIndentTabString(numTabIndents))
    End Function

    Friend Function PrintFields(indentString As String) As String
        Dim s As String = ""
        s &= indentString & "SOURCE: " & Me.Source & vbCrLf
        s &= indentString & "ACTION: " & Me.Action & vbCrLf
        s &= indentString & "TEXT: " & Me.Text & vbCrLf
        s &= indentString & "TARGET: " & Me.Target & vbCrLf
        s &= indentString & "FACTOID NUMBER: " & Me.FactoidNumber & vbCrLf
        Return s
    End Function

    Friend Function IsComment() As Boolean
        If Me.Action.ToUpper = "COMMENT" Then
            Return True
        Else
            Return False
        End If
    End Function

    Friend Function IsFromSystem() As Boolean
        If Me.Source = "SYSTEM" Then
            Return True
        Else
            Return False
        End If
    End Function

    Private Function GetIndentTabString(num As Integer) As String
        Dim s As String = ""
        For I As Integer = 0 To num
            s &= vbTab
        Next
        Return s
    End Function

    Friend Shared Function Parse(messageText As String) As Message
        Dim data As String = messageText
        data = data.Replace(vbCr, String.Empty)
        data = data.Replace(vbLf, String.Empty)
        data = data.Replace(vbCrLf, String.Empty)
        data = data.Trim
        If data = String.Empty Then
            Throw New EmptyMessageException("Message has no content.")
        End If
        Dim m As New Message
        Try
            Dim sArray() As String = data.Split(Message.SeparatorCharacter.ToCharArray)
            m.Source = sArray(0)
            m.Action = sArray(1)
            m.Text = sArray(2)
            m.Target = sArray(3)
            m.FactoidNumber = sArray(4)
            Return m
        Catch ex As Exception
            Throw New MessageNotInterpretableException("Message could not be interpreted:" & vbCrLf & vbCrLf & messageText)
        End Try
    End Function

End Class

Public Class EmptyMessageException
    Inherits ApplicationException

    Sub New(msg As String)
        MyBase.New(msg)
    End Sub
End Class

Public Class MessageNotInterpretableException
    Inherits ApplicationException

    Sub New(msg As String)
        MyBase.New(msg)
    End Sub
End Class
